#!/usr/bin/env ruby

$KCODE = 'u'

load "lib/jte.rb"


# function の使用例

def page_head( jte, element, data )
  html = ''
  html << '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />' + "\n"
  html << '<title>' + jte.escapeHTML( 'JTE サンプル 実行後(Ruby)' ) + '</title>' + "\n"
  
  # innerHTML
  
  while element.childNodes.length > 0
    element.removeChild( element.firstChild )
  end
  
  jte._parse( element, html )
end


# jte へのデータを準備
# 実際はデータベースなどから設定します。

data = {
  'condition'   => {},
  'value'       => {},
  'record'      => {},
  'function'    => {}
}

data[ 'condition' ][ 'case_1' ] = true
data[ 'condition' ][ 'case_2' ] = false

data[ 'condition' ][ 'column_1' ] = true
data[ 'condition' ][ 'column_2' ] = false

data[ 'value' ][ 'template' ] = ''
data[ 'value' ][ 'text_inner' ] = 'innerで内容を書き換えました。<br />複数のエレメントを記述できます。'
data[ 'value' ][ 'text_outer' ] = 'outerでタグを書き換えました。<br />複数のエレメントを記述できます。<br />'

data[ 'value' ][ 'copyright_url' ] = 'http://www.japro.net'
data[ 'value' ][ 'copyright_name' ] = 'JAPRO(C)'

data[ 'record' ][ 'list' ] = []

data[ 'record' ][ 'list' ].push( { 'value' => {
  'url' => 'http://www.google.co.jp/',
  'name' => 'Google'
} } )

data[ 'record' ][ 'list' ].push( { 'value' => {
    'url' => 'http://www.yahoo.co.jp/',
    'name' => 'Yahoo! Japan'
} } )

# 関数は [ obj, name ] / obj.method( name ) で設定

#data[ 'function' ][ 'head' ] = [ self, 'page_head' ]
data[ 'function' ][ 'head' ] = method( 'page_head' ) 


# テンプレートにデータを適用して表示

print "Content-Type: text/html; charset=UTF-8\n"
print "\n"

jte = JTE.new

jte.execute( 'template/default.html', data )
